<div class="panel">
    <div class="panel-heading panel-theme clearfix report-head">
        List of Provisional Report
        <div class="pull-right">
            <div class="filter_details">
                <?php if ($provisional_from_date != '') { ?>
                    <div class="filter-item">
                        <label>Provisional From :</label>
                        <?php echo $provisional_from_date; ?>
                    </div>
                    <?php
                }
                if ($provisional_to_date != '') {
                    ?>
                    <div class="filter-item">
                        <label>Provisional To :</label>
                        <?php echo $provisional_to_date; ?>
                    </div>
                
                
                  <?php } if ($provisional_customer_id != '') { ?>
                  <div class="filter-item">
                  <label>Customer</label>
                  <?php echo Customer::model()->findByPK($provisional_customer_id)->customer_name; ?>
                  </div>
                  <?php } 
                ?>
            </div>
        </div>
    </div>
    <div class="panel-body">
        <div class="table-responsive">
            <table id="tbl_invoice_table" class="table table-fixed table-bordered table-primary dataTable" style="font-size:12px;">
                <thead>
                    <tr>
                        <th>No</th>
                        <th>Job No</th>
                        <th>Customer</th>
                        <th>Lead Owner
                        <th>Invoice Date</th>
                        <th>Invoice No</th>
                        <th>Selling Price</th>
                        <th>Planned Cost</th>
                        <th>Planned Profit</th>
                        <th>Invoice Amount</th>
                        <th>Actual Cost</th>
                        <th>Actual Profit</th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    $condition="job_order_status!='CN'";


                    if ($provisional_from_date != '') {
                        $provisional_from_date = str_replace('/', '-', $provisional_from_date);
                        $provisional_from_date = date('Y-m-d', strtotime($provisional_from_date));
                        $condition .= ' AND t.job_date >="' . $provisional_from_date . '"';
                    }
                    if ($provisional_to_date != '') {
                        $provisional_to_date = str_replace('/', '-', $provisional_to_date);
                        $provisional_to_date = date('Y-m-d', strtotime($provisional_to_date));
                        $condition .= ' AND t.job_date <="' . $provisional_to_date . '"';
                    }


                     if ($provisional_customer_id > 0) {

                      $condition .= ' AND t.customer_id ="' . $provisional_customer_id . '"';
                      }
                      if ($provisional_leadowner_id > 0) {

                      $condition .= ' AND t.lead_owner_id ="' . $provisional_leadowner_id . '"';
                      }
                      
                       if ($job_order_id!="") {

                      $condition .= ' AND t.id ="' . $job_order_id . '"';
                      }

                     /* if ($activity != '') {

                      $condition .= ' AND t.type_of_activity ="' . $activity . '"';
                      }
                      if ($activity_type != '') {

                      $condition .= ' AND t.activity_id ="' . $activity_type . '"';
                      }

                      if ($added_from != '') {

                      $condition .= ' AND t.added_from ="' . $added_from . '"';
                      }

                      /* if($activity_user != ''){

                      $condition .= ' AND t.crm_user_id ="'.$activity_user.'"';
                      } */
                    //echo $condition;
                    $model_provisional = JobOrder::model()->with('customer', 'invoice')->findAll(array('condition' => $condition,'order'=>'t.id DESC'));

                    $total = 0;
                    $actual_cost = 0;
                    $total_selling_price=0;
                    $total_planned_cost = 0;
                    $total_planned_profit=0;
                    $total_invoice_amount=0;
                    $total_actual_cost=0;
                    $total_actual_profit=0;

                    foreach ($model_provisional as $i => $model) {
                        
                        
                        $arr_invoice_item_details = InvoiceItem::model()->find(array('condition'=>'order_item_id='.$model->id));
                        
                        $invoice_amount =$arr_invoice_item_details['net_amount'] + $arr_invoice_item_details['tax_vat_amount'];
                        
                        $SQL="SELECT SUM(planned_selling_price) AS total_selling_price,SUM(planned_cost) AS total_planned_cost,SUM(actual_cost) AS total_actual_cost FROM erp_job_order_agent_details WHERE `job_order_id`=".$model->id;
                        $arr_totals= Yii::app()->db->createCommand($SQL)->queryAll();
                        $planned_selling_price = $arr_totals[0]['total_selling_price'];
                        $planned_cost = $arr_totals[0]['total_planned_cost'];
                        $actual_cost = $arr_totals[0]['total_actual_cost'];
                        ?>

                        <tr>

                            <td width="2%"><?php echo $i + 1; ?></td>

                            <td width="5%"><?php echo $model->id; ?></td>
                            <td width="15%"><?php echo $model->customer->customer_name; ?></td>
                            <td width="10%">
                                <?php 
                                echo $model->leadowner->first_name.' '.$model->leadowner->last_name;?>
                            </td>
                            <?php if ($model->invoice->invoice_date != "" && $model->invoice->invoice_date != '0000-00-00') { ?>
                                <td width="5%"><?php echo date("d/m/Y", strtotime($model->invoice->invoice_date)); ?></td>
                           <?php } else { ?>
                                <td> </td>

                            <?php } ?>
                            <td width="5%"><?php echo $model->invoice->id; 
                            $planned_profit =$planned_selling_price-$planned_cost;
                            $actual_profit =$invoice_amount-$actual_cost;
                            
                            $planned_profit_style="";
                            if($planned_profit < 0){
                                 $planned_profit_style="color:red"; 
                            }
                            
                            $actual_profit_style="";
                            if($planned_profit > $actual_profit){
                                 $actual_profit_style="color:red"; 
                            }
                            else if($planned_profit < $actual_profit){
                                 $actual_profit_style="color:green"; 
                            }
                            
                            
                            ?></td>
                            <td width="5%" class="text-right"><?php echo Yii::app()->numberFormatter->formatCurrency($planned_selling_price, ""); ?></td>
                            <td width="5%" class="text-right"><?php echo Yii::app()->numberFormatter->formatCurrency($planned_cost, ""); ?></td>
                            <td width="5%" class="text-right" style="<?php echo $planned_profit_style;?>"><?php echo Yii::app()->numberFormatter->formatCurrency($planned_profit, ""); ?></td>
                            <td width="5%" class="text-right"><?php echo Yii::app()->numberFormatter->formatCurrency($invoice_amount, ""); ?></td>
                            <td width="5%" class="text-right"><?php echo Yii::app()->numberFormatter->formatCurrency($actual_cost, ""); ?></td>
                            <td width="5%" class="text-right" style="<?php echo $actual_profit_style;?>"><?php echo Yii::app()->numberFormatter->formatCurrency($actual_profit, ""); ?></td>
                            <?php
                            $grand_total = $invoice_amount;
                            $total_planned_cost+= $planned_cost;
                            $actulcost = $actual_cost;
                            $total_invoice_amount += $grand_total;
                            $total_actual_cost += $actulcost;
                            $total_selling_price+=$planned_selling_price;
                            $total_planned_profit+=$planned_profit;
                            $total_actual_profit+=$actual_profit;
                            ?>

                        </tr>
                       <?php } ?>

                    <tr>
                        <td colspan="6"> </td>
                        <td class="text-right"><b><?php echo Yii::app()->numberFormatter->formatCurrency($total_selling_price, " "); ?></b></td>
                        <td class="text-right"><b><?php echo Yii::app()->numberFormatter->formatCurrency($total_planned_cost, " "); ?></b></td>
                        <td class="text-right"><b><?php echo Yii::app()->numberFormatter->formatCurrency($total_planned_profit, " "); ?></b></td>
                        <td class="text-right"><b><?php echo Yii::app()->numberFormatter->formatCurrency($total_invoice_amount, " "); ?></b></td>
                        <td class="text-right"><b><?php echo Yii::app()->numberFormatter->formatCurrency($total_actual_cost, " "); ?></b></td>
                        <td class="text-right"><b> <?php echo Yii::app()->numberFormatter->formatCurrency($total_actual_profit, " "); ?></b> </td>
                    </tr>
                </tbody>
            </table>
            <br>
            <div class="btn-wrap text-center">
                     <?php
                echo CHtml::link('Export PDF', array('reports/PrintProvisionalPdf','provisional_from_date' => $provisional_from_date, 'provisional_to_date' => $provisional_to_date,'provisional_customer_id' => $provisional_customer_id,'provisional_leadowner_id' => $provisional_leadowner_id), array('title' => 'Print Provisional List', 'target' => '_blank', 'class' => 'btn btn-theme'));
                ?>

                <button type="button" class="btn btn-theme" onclick="excelProvisionalList();">Export Excel</button> 


            </div>
        </div>
    </div>
</div>
<?php
$cs = Yii::app()->getClientScript();

$cs->registerScript("excelProvisionalList", "function excelProvisionalList(){

    
    var provisional_to_date = $('#provisional_to_date').val();
    var provisional_from_date = $('#provisional_from_date').val();    
    var provisional_customer_id = $('#provisional_customer_id').val();
    var provisional_leadowner_id = $('#provisional_leadowner_id').val();
    var param = 'provisional_to_date='+provisional_to_date+'&provisional_from_date='+provisional_from_date+'&provisional_customer_id='+provisional_customer_id+'&provisional_leadowner_id='+provisional_leadowner_id;
    window.open($('#liveSite').val()+'index.php?r=reports/ProvisionalListExcel&'+param, '_blank');

}", CClientScript::POS_HEAD);
?>